/*
 * Decompiled with CFR 0.152.
 */
package com.huaban.analysis.jieba;

import com.huaban.analysis.jieba.DictSegment;
import com.huaban.analysis.jieba.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class WordDictionary {
    private static WordDictionary singleton;
    private static final String MAIN_DICT = "/dict.txt";
    private static String USER_DICT_SUFFIX;
    public final Map<String, Double> freqs = new HashMap<String, Double>();
    public final Set<String> loadedPath = new HashSet<String>();
    private Double minFreq = Double.MAX_VALUE;
    private Double total = 0.0;
    private DictSegment _dict;

    private WordDictionary() {
        this.loadDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WordDictionary getInstance() {
        if (singleton != null) return singleton;
        Class<WordDictionary> clazz = WordDictionary.class;
        synchronized (WordDictionary.class) {
            if (singleton != null) return singleton;
            singleton = new WordDictionary();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Path configFile) {
        String abspath = configFile.toAbsolutePath().toString();
        Log.debug("initialize user dictionary:" + abspath);
        Class<WordDictionary> clazz = WordDictionary.class;
        synchronized (WordDictionary.class) {
            if (this.loadedPath.contains(abspath)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(configFile, String.format(Locale.getDefault(), "*%s", USER_DICT_SUFFIX));
                for (Path path : stream) {
                    Log.error(String.format(Locale.getDefault(), "loading dict %s", path.toString()));
                    singleton.loadUserDict(path);
                }
                this.loadedPath.add(abspath);
            }
            catch (IOException e) {
                Log.error(String.format(Locale.getDefault(), "%s: load user dict failure!", configFile.toString()));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] paths) {
        Class<WordDictionary> clazz = WordDictionary.class;
        synchronized (WordDictionary.class) {
            for (String path : paths) {
                if (this.loadedPath.contains(path)) continue;
                try {
                    Log.debug("initialize user dictionary: " + path);
                    singleton.loadUserDict(path);
                    this.loadedPath.add(path);
                }
                catch (Exception e) {
                    Log.error(String.format(Locale.getDefault(), "%s: load user dict failure!", path));
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void resetDict() {
        this._dict = new DictSegment(Character.valueOf('\u0000'));
        this.freqs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadDict() {
        block15: {
            this._dict = new DictSegment(Character.valueOf('\u0000'));
            InputStream is = this.getClass().getResourceAsStream(MAIN_DICT);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            long s = System.currentTimeMillis();
            while (br.ready()) {
                String line = br.readLine();
                String[] tokens = line.split("[\t ]+");
                if (tokens.length < 2) continue;
                String word = tokens[0];
                double freq = Double.valueOf(tokens[1]);
                this.total = this.total + freq;
                word = this.addWord(word);
                this.freqs.put(word, freq);
            }
            for (Map.Entry<String, Double> entry : this.freqs.entrySet()) {
                entry.setValue(Math.log(entry.getValue() / this.total));
                this.minFreq = Math.min(entry.getValue(), this.minFreq);
            }
            Log.debug(String.format(Locale.getDefault(), "main dict load finished, time elapsed %d ms", System.currentTimeMillis() - s));
            try {
                if (null != is) {
                    is.close();
                }
                break block15;
            }
            catch (IOException e) {
                Log.error(String.format(Locale.getDefault(), "%s close failure!", MAIN_DICT));
            }
            break block15;
            catch (IOException e) {
                try {
                    Log.error(String.format(Locale.getDefault(), "%s load failure!", MAIN_DICT));
                }
                catch (Throwable throwable) {
                    try {
                        if (null != is) {
                            is.close();
                        }
                    }
                    catch (IOException e2) {
                        Log.error(String.format(Locale.getDefault(), "%s close failure!", MAIN_DICT));
                    }
                    throw throwable;
                }
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException e3) {
                    Log.error(String.format(Locale.getDefault(), "%s close failure!", MAIN_DICT));
                }
            }
        }
    }

    private String addWord(String word) {
        if (null != word && !"".equals(word.trim())) {
            String key = word.trim().toLowerCase(Locale.getDefault());
            this._dict.fillSegment(key.toCharArray());
            return key;
        }
        return null;
    }

    public void loadUserDict(Path userDict) {
        this.loadUserDict(userDict, StandardCharsets.UTF_8);
    }

    public void loadUserDict(String userDictPath) {
        this.loadUserDict(userDictPath, StandardCharsets.UTF_8);
    }

    public void loadUserDict(Path userDict, Charset charset) {
        try {
            BufferedReader br = Files.newBufferedReader(userDict, charset);
            long s = System.currentTimeMillis();
            int count = 0;
            while (br.ready()) {
                String line = br.readLine();
                String[] tokens = line.split("[\t ]+");
                if (tokens.length < 1) continue;
                String word = tokens[0];
                double freq = 3.0;
                if (tokens.length == 2) {
                    freq = Double.valueOf(tokens[1]);
                }
                word = this.addWord(word);
                this.freqs.put(word, Math.log(freq / this.total));
                ++count;
            }
            Log.debug(String.format(Locale.getDefault(), "user dict %s load finished, tot words:%d, time elapsed:%dms", userDict.toString(), count, System.currentTimeMillis() - s));
            br.close();
        }
        catch (IOException e) {
            Log.error(String.format(Locale.getDefault(), "%s: load user dict failure!", userDict.toString()));
        }
    }

    public void loadUserDict(String userDictPath, Charset charset) {
        InputStream is = this.getClass().getResourceAsStream(userDictPath);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, charset));
            long s = System.currentTimeMillis();
            int count = 0;
            while (br.ready()) {
                String line = br.readLine();
                String[] tokens = line.split("[\t ]+");
                if (tokens.length < 1) continue;
                String word = tokens[0];
                double freq = 3.0;
                if (tokens.length == 2) {
                    freq = Double.valueOf(tokens[1]);
                }
                word = this.addWord(word);
                this.freqs.put(word, Math.log(freq / this.total));
                ++count;
            }
            Log.debug(String.format(Locale.getDefault(), "user dict %s load finished, tot words:%d, time elapsed:%dms", userDictPath, count, System.currentTimeMillis() - s));
            br.close();
        }
        catch (IOException e) {
            Log.error(String.format(Locale.getDefault(), "%s: load user dict failure!", userDictPath));
        }
    }

    public DictSegment getTrie() {
        return this._dict;
    }

    public boolean containsWord(String word) {
        return this.freqs.containsKey(word);
    }

    public Double getFreq(String key) {
        if (this.containsWord(key)) {
            return this.freqs.get(key);
        }
        return this.minFreq;
    }

    static {
        USER_DICT_SUFFIX = ".dict";
    }
}

