/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.nlp.common.segment.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.nlp.common.dfa.tree.ITrieTreeMap;
import com.github.houbb.nlp.common.segment.impl.SimpleCommonSegment;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class FastForwardCommonSegment
extends SimpleCommonSegment {
    private final ITrieTreeMap trieTreeMap;

    public FastForwardCommonSegment(ITrieTreeMap trieTreeMap) {
        this.trieTreeMap = trieTreeMap;
    }

    @Override
    protected List<String> getChineseSegments(String text) {
        List<String> resultList = Guavas.newArrayList();
        for (int i = 0; i < text.length(); ++i) {
            int wordLength = this.getWordMatchLength(text, i);
            if (wordLength > 0) {
                String phrase = text.substring(i, i + wordLength);
                resultList.add(phrase);
                i += wordLength - 1;
                continue;
            }
            resultList.add(String.valueOf(text.charAt(i)));
        }
        return resultList;
    }

    private int getWordMatchLength(String txt, int beginIndex) {
        Map nowMap = this.trieTreeMap.getTrieTreeMap();
        int lengthCount = 0;
        int actualLength = 0;
        for (int i = beginIndex; i < txt.length() && ObjectUtil.isNotNull(nowMap = this.getCurrentMap(nowMap, txt, i)); ++i) {
            ++lengthCount;
            boolean isEnd = FastForwardCommonSegment.isEnd(nowMap);
            if (!isEnd) continue;
            actualLength = lengthCount;
        }
        return actualLength;
    }

    private Map getCurrentMap(Map nowMap, String txt, int index) {
        char charAt = txt.charAt(index);
        return (Map)nowMap.get(Character.valueOf(charAt));
    }

    private static boolean isEnd(Map map) {
        if (ObjectUtil.isNull(map)) {
            return false;
        }
        Object value = map.get("ED");
        if (ObjectUtil.isNull(value)) {
            return false;
        }
        return (Boolean)value;
    }
}

