/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.core.impl;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.opencc4j.core.ZhConvert;
import com.github.houbb.opencc4j.support.convert.context.impl.DefaultUnitConvertContext;
import com.github.houbb.opencc4j.support.convert.core.UnitConvert;
import com.github.houbb.opencc4j.support.convert.core.impl.DefaultUnitConvert;
import com.github.houbb.opencc4j.support.datamap.IDataMap;
import com.github.houbb.opencc4j.support.datamap.impl.DataMaps;
import com.github.houbb.opencc4j.support.segment.Segment;
import com.github.houbb.opencc4j.support.segment.impl.Segments;
import java.util.List;
import java.util.Map;

public class ZhConvertBootstrap
implements ZhConvert {
    private Segment segment = Segments.defaults();
    private IDataMap dataMap = DataMaps.defaults();

    private ZhConvertBootstrap() {
    }

    public static ZhConvertBootstrap newInstance() {
        return new ZhConvertBootstrap();
    }

    @Deprecated
    public static ZhConvertBootstrap newInstance(Segment segment) {
        ZhConvertBootstrap bs = ZhConvertBootstrap.newInstance();
        bs.segment(segment);
        return bs;
    }

    public ZhConvertBootstrap segment(Segment segment) {
        ArgUtil.notNull(segment, "segment");
        this.segment = segment;
        return this;
    }

    public ZhConvertBootstrap dataMap(IDataMap dataMap) {
        this.dataMap = dataMap;
        return this;
    }

    @Override
    public String toSimple(String original) {
        return this.convert(original, this.segment, this.dataMap.tsPhrase(), this.dataMap.tsChar());
    }

    @Override
    public String toTraditional(String original) {
        return this.convert(original, this.segment, this.dataMap.stPhrase(), this.dataMap.stChar());
    }

    @Override
    @Deprecated
    public List<String> doSeg(String original) {
        if (StringUtil.isEmpty(original)) {
            return Guavas.newArrayList();
        }
        return this.segment.seg(original);
    }

    @Override
    public List<String> simpleList(String original) {
        List<String> simpleList = Guavas.newArrayList();
        List<String> segList = this.doSeg(original);
        for (String seg : segList) {
            if (!this.isSimple(seg)) continue;
            simpleList.add(seg);
        }
        return simpleList;
    }

    @Override
    public List<String> traditionalList(String original) {
        List<String> traditionalList = Guavas.newArrayList();
        List<String> segList = this.doSeg(original);
        for (String seg : segList) {
            if (!this.isTraditional(seg)) continue;
            traditionalList.add(seg);
        }
        return traditionalList;
    }

    @Override
    public boolean isSimple(char c) {
        if (!this.isChinese(c)) {
            return false;
        }
        if (this.dataMap.sChars().contains(c + "")) {
            return true;
        }
        return !this.isTraditional(c);
    }

    @Override
    public boolean isSimple(String charOrPhrase) {
        char[] chars;
        if (StringUtil.isEmpty(charOrPhrase)) {
            return false;
        }
        for (char c : chars = charOrPhrase.toCharArray()) {
            if (this.isSimple(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsSimple(String charOrPhrase) {
        char[] chars;
        if (StringUtil.isEmpty(charOrPhrase)) {
            return false;
        }
        for (char c : chars = charOrPhrase.toCharArray()) {
            if (!this.isSimple(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTraditional(char c) {
        if (!this.isChinese(c)) {
            return false;
        }
        return this.dataMap.tChars().contains(c + "");
    }

    @Override
    public boolean isTraditional(String charOrPhrase) {
        char[] chars;
        if (StringUtil.isEmpty(charOrPhrase)) {
            return false;
        }
        for (char c : chars = charOrPhrase.toCharArray()) {
            if (this.isTraditional(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsTraditional(String charOrPhrase) {
        char[] chars;
        if (StringUtil.isEmpty(charOrPhrase)) {
            return false;
        }
        for (char c : chars = charOrPhrase.toCharArray()) {
            if (!this.isTraditional(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChinese(char c) {
        return CharUtil.isChinese(c);
    }

    @Override
    public boolean isChinese(String charOrPhrase) {
        char[] chars;
        if (StringUtil.isEmpty(charOrPhrase)) {
            return false;
        }
        for (char c : chars = charOrPhrase.toCharArray()) {
            if (this.isChinese(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsChinese(String charOrPhrase) {
        char[] chars;
        if (StringUtil.isEmpty(charOrPhrase)) {
            return false;
        }
        for (char c : chars = charOrPhrase.toCharArray()) {
            if (!this.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> toSimple(char c) {
        return this.dataMap.tsChar().get(String.valueOf(c));
    }

    @Override
    public List<String> toTraditional(char c) {
        return this.dataMap.stChar().get(String.valueOf(c));
    }

    protected String convert(String original, Segment segment, Map<String, List<String>> phraseData, Map<String, List<String>> charData) {
        if (StringUtil.isEmpty(original)) {
            return original;
        }
        List<String> stringList = segment.seg(original);
        if (CollectionUtil.isEmpty(stringList)) {
            return original;
        }
        UnitConvert unitConvert = Instances.singleton(DefaultUnitConvert.class);
        DefaultUnitConvertContext unitConvertContext = new DefaultUnitConvertContext();
        unitConvertContext.setPhraseData(phraseData);
        unitConvertContext.setCharData(charData);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringList) {
            unitConvertContext.setUnit(string);
            String result = unitConvert.convert(unitConvertContext);
            stringBuilder.append(result);
        }
        return stringBuilder.toString();
    }
}

