/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.nlp.common.format.impl;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.support.pipeline.Pipeline;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.nlp.common.format.ICharFormat;
import com.github.houbb.nlp.common.format.impl.AbstractCharFormatInit;
import com.github.houbb.nlp.common.format.impl.ChineseTsCharFormat;
import com.github.houbb.nlp.common.format.impl.HalfWidthCharFormat;
import com.github.houbb.nlp.common.format.impl.LowerCaseCharFormat;
import com.github.houbb.nlp.common.format.impl.NoneCharFormat;

public final class CharFormats {
    private CharFormats() {
    }

    public static ICharFormat defaults() {
        return CharFormats.chains(CharFormats.halfWidth(), CharFormats.lowerCase());
    }

    public static ICharFormat halfWidth() {
        return Instances.singleton(HalfWidthCharFormat.class);
    }

    public static ICharFormat lowerCase() {
        return Instances.singleton(LowerCaseCharFormat.class);
    }

    public static ICharFormat none() {
        return Instances.singleton(NoneCharFormat.class);
    }

    public static ICharFormat chineseSimple() {
        return Instances.singleton(ChineseTsCharFormat.class);
    }

    public static ICharFormat chains(final ICharFormat ... formats) {
        if (ArrayUtil.isEmpty(formats)) {
            return CharFormats.none();
        }
        return new AbstractCharFormatInit(){

            @Override
            protected void init(Pipeline<ICharFormat> pipeline) {
                for (ICharFormat format : formats) {
                    pipeline.addLast(format);
                }
            }
        };
    }
}

